# Dogecoin Core file system

**Contents**

- [Data directory location](#data-directory-location)
- [Data directory layout](#data-directory-layout)
- [GUI settings](#gui-settings)
- [Legacy subdirectories and files](#legacy-subdirectories-and-files)
- [Notes](#notes)

## Data directory location

The data directory is the default location where the Dogecoin Core files are stored.

1. The default data directory paths for supported platforms are:

Platform | Data directory path
---------|--------------------
Linux    | `$HOME/.dogecoin/`
macOS    | `$HOME/Library/Application Support/Dogecoin/`
Windows  | `%APPDATA%\Dogecoin\` <sup>[\[1\]](#note1)</sup>

2. A custom data directory path can be specified with the `-datadir` option.

3. All content of the data directory, except for the `dogecoin.conf` file, is chain-specific. This means the actual data directory paths for non-mainnet cases differ:

Chain         | Data directory path
--------------|------------------------------
(default)     | *path_to_datadir*`/`
`-testnet`    | *path_to_datadir*`/testnet3/`
`-regtest`    | *path_to_datadir*`/regtest/`

## Data directory layout

Subdirectory       | File(s)               | Description
-------------------|-----------------------|------------
`blocks/`          |                       | Blocks directory
`blocks/index/`    | LevelDB database      | Block and transaction indices
`blocks/`          | `blkNNNNN.dat`        | Actual blocks (in network format, dumped in raw on disk, 128 MiB per file)
`blocks/`          | `revNNNNN.dat`        | Block undo data (custom format)
`chainstate/`      | LevelDB database      | Blockchain state, a.k.a UTXO database
`./`               | `anchors.dat`         | Anchor IP address database, created on shutdown and deleted at startup. Anchors are last known outgoing block-relay-only peers that are tried to re-connect to on startup
`./`               | `banlist.dat`         | Stores the IPs/subnets of banned nodes
`./`               | `dogecoin.conf`       | User-defined configuration settings for `dogecoind` or `dogecoin-qt`; can be specified by `-conf` option
`./`               | `dogecoind.pid`        | Stores the process ID (PID) of `dogecoind` or `dogecoin-qt` while running; can be specified by `-pid` option
`./`               | `debug.log`           | Contains debug information and general logging generated by `dogecoind` or `dogecoin-qt`
`./`               | `fee_estimates.dat`   | Stores statistics used to estimate smart transaction fees and priorities required for confirmation
`./`               | `mempool.dat`         | Dump of the mempool's transactions
`./`               | `onion_private_key`   | Cached Tor onion service private key for `-listenonion` option
`./`               | `peers.dat`           | Peer IP address database
`./`               | `.cookie`             | Session RPC authentication cookie; if used, created at start and deleted on shutdown; can be specified by `-rpccookiefile` option
`./`               | `.lock`               | Data directory lock file
`./`               | `db.log`              | BDB error file
`./`               | `wallet.dat`          | Personal wallet (a BDB database) with keys and transactions
`./`               | `.walletlock`         | BDB wallet lock file

## GUI settings

`dogecoin-qt` uses the [`QSettings`](https://doc.qt.io/qt-5/qsettings.html) class; this implies platform-specific [locations where application settings are stored](https://doc.qt.io/qt-5/qsettings.html#locations-where-application-settings-are-stored).

## Legacy subdirectories and files

These subdirectories and files are no longer used by Dogecoin Core:

Path           | Description
---------------|-------------
`blktree/`     | Blockchain index; replaced by `blocks/index/` in 1.10.0
`coins/`       | Unspent transaction output database; replaced by `chainstate/` in 1.10.0
`blkindex.dat` | Blockchain index BDB database; replaced by {`chainstate/`, `blocks/index/`, `blocks/revNNNNN.dat`} in 1.10.0
`blk000?.dat`  | Block data (custom format, 2 GiB per file); replaced by `blocks/blkNNNNN.dat` in 1.10.0
`addr.dat`     | Peer IP address BDB database; replaced by `peers.dat` in 1.7.0

## Notes

<a name="note1">1</a>. The `/` (slash, U+002F) is used as the platform-independent path component separator in this document.
